# AKBS: The **A**ll **K**nowing **B**uild **S**ystem for C, C++ and Assembly

## Requirements
Python 3>=

## Installation
```bash
# Linux
python3 -m pip install akbs
# Windows (UNSUPPORTED!)
python -m pip install akbs


# Usage
python3 -m akbs
```
## Speed
To test the build system, I made a build script for [basic_math_operations](https://github.com/avighnac/basic_math_operations),
It took 1.205 seconds to compile and link, as well as check for the required compiler and 3 seconds on average (it hit 3.5 and 2.5 a couple of times).

The `build.akbs` file is as follows
```
set(C_STD, 17)
set(CXX_STD, 17)
set(OUTPUT, abcd.so)
set(FILES, wildcard$(src/library/**/*.cpp) wildcard$(src/library/**/*.c*))
set(BUILD_DIR, build)
set(OUTPUT_DIR, dist)

if(eq($PLATFORM, UNIX))
set(FILES, wildcard$(src/library/linux/*.asm) remove$($FILES, src/library/cross-platform/addp.c src/library/cross-platform/multiply-whole.c))
endif

check_for(C, CXX, ASM_INTEL, LINKER)


compile(SHARED, $FILES)
```
**Note:** The `remove$()` helper function is used because the `multiply_whole` and `addp` functions are already present in Assembly for Linux, not for Windows

## How do you use AKBS?
By default, the build script is called `build.akbs`, similar to `Makefile` and `CMakeLists.txt`

To enable languages, you use the `check_for` function
```
check_for(C, CXX, ASM_INTEL, ASM_ATT, LINKER)
```
Right now, only these 4 languages (and a linker) (3 if you count AT&T and Intel syntax Assembly as one language) are supported

If you want to set the standard of C and C++, set the C_STD or CXX_STD variable
```
set(C_STD, 17)
set(CXX_STD, 17)
```

To compile a list of files, use the compile function
```
compile(SHARED/STATIC, src/a.c src/b.c src/c.c)
```

To print a statement you can use the print statement
```
print $PLATFORM
```
To use a variable, use `$VARIABLENAME`

The `$PLATFORM` variable comes predefined and is set to `os.name`

For conditions, use if (else and else if are not implemented yet) and endif.

Inside the if, if the condition is just a variable name, it enters if the variable is defined, else it continues on.

If there is an `eq()` function (more to be implemented soon), it compares if two strings are equal (variables work too obviously)

```
if(PLATFORM)
print $PLATFORM
if(eq(PLATFORM, UNIX))
print Yay, we're in UNIX land
endif
endif
```

Also, there is a rudimentary pre-processor, with `%define`

```
%define ifend endif
if(PLATFORM)
ifend
```

There is also a list of helper functions

| Function Name | Arguments | Description | Introduced
|---|---|---|---|
| wildcard$ | str1 | Evaluates a list of space separated globs into a space separated list of files | v1.0.0
| remove$ | str1, str2, str3... | Removes str2 onwards from a space separated list of strings | v1.0.0

A list of important variables are
| Variable | Is Set | Description | Introduced |
|---|---|---|---|
| PLATFORM | Yes | Equivalent of `os.name` | v1.0.0 |
| C_COMPILER | No | C compiler location set by `check_for` | v1.0.0 |
| CXX_COMPILER | No | C++ compiler location set by `check_for` | v1.0.0 |
| ASM_INTEL_COMPILER | No | Intel Assembly assembler location set by `check_for` | v1.0.0 |
| ASM_ATT_COMPILER | No | AT&T Assembly assembler location set by `check_for` | v1.0.0 |
| LINKER_COMPILER | No | Linker location set by `check_for` | v1.0.0 |
| OUTPUT | No | Output file generated by linking | v1.0.0 |
| C_STD | No | The C std used (just the number like 17, 11, etc.) | v1.0.0 |
| CXX_STD | No | The C++ std used (just the number like 17, 11, etc.) | v1.0.0 |
| BUILD_DIR | No | The directory to build the objects in | v1.0.1 |
| OUTPUT_DIR | No | The directory to output the finished objects in in | v1.0.1 |


## How to clean the files
```bash
find -name "*.o" -exec "rm" "{}" ";"
rm .hashes 
```

## To-Do
* [x] Build directory (milestone 1.0.1)
* [ ] Nested functions
* [ ] Windows support
* [ ] Optimization
* [ ] Subdirectories
* [ ] Ability to set compilers from `set()` and environment variables
* [ ] More if conditions
* [ ] `replace$()` helper function
* [ ] clean command
* [ ] Documenting my code + Readable variables
* [ ] C_FLAGS, CXX_FLAGS, ASM...
* [ ] Cache install locations (milestone 1.0.2)
* [ ] Ability to set target architecture

