"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PDKPipeline = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
const pdk_nag_1 = require("@aws-prototyping-sdk/pdk-nag");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_codecommit_1 = require("aws-cdk-lib/aws-codecommit");
const aws_codepipeline_1 = require("aws-cdk-lib/aws-codepipeline");
const aws_s3_1 = require("aws-cdk-lib/aws-s3");
const pipelines_1 = require("aws-cdk-lib/pipelines");
const cdk_nag_1 = require("cdk-nag");
const sonar_code_scanner_1 = require("./code_scanner/sonar-code-scanner");
__exportStar(require("./code_scanner/sonar-code-scanner"), exports);
const DEFAULT_BRANCH_NAME = "mainline";
/**
 * An extension to CodePipeline which configures sane defaults for a NX Monorepo
 * codebase. In addition to this, it also creates a CodeCommit repository with
 * automated PR builds and approvals.
 */
class PDKPipeline extends pipelines_1.CodePipeline {
    constructor(scope, id, props) {
        const codeRepository = new aws_codecommit_1.Repository(scope, "CodeRepository", {
            repositoryName: props.repositoryName,
        });
        codeRepository.applyRemovalPolicy(props.codeCommitRemovalPolicy ?? aws_cdk_lib_1.RemovalPolicy.RETAIN);
        const artifactBucket = new aws_s3_1.Bucket(scope, "ArtifactsBucket", {
            enforceSSL: true,
            autoDeleteObjects: true,
            removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY,
            encryption: aws_s3_1.BucketEncryption.S3_MANAGED,
            publicReadAccess: false,
            blockPublicAccess: aws_s3_1.BlockPublicAccess.BLOCK_ALL,
            serverAccessLogsPrefix: "access-logs",
        });
        const codePipeline = new aws_codepipeline_1.Pipeline(scope, "CodePipeline", {
            enableKeyRotation: true,
            restartExecutionOnUpdate: true,
            crossAccountKeys: props.crossAccountKeys,
            artifactBucket,
        });
        // ignore input and primaryOutputDirectory
        const { input, primaryOutputDirectory, commands, ...synthShellStepPartialProps } = props.synthShellStepPartialProps || {};
        const synthShellStep = new pipelines_1.ShellStep("Synth", {
            input: pipelines_1.CodePipelineSource.codeCommit(codeRepository, props.defaultBranchName || DEFAULT_BRANCH_NAME),
            installCommands: ["yarn install --frozen-lockfile"],
            commands: commands && commands.length > 0
                ? commands
                : ["npx nx run-many --target=build --all"],
            primaryOutputDirectory: props.primarySynthDirectory,
            ...(synthShellStepPartialProps || {}),
        });
        synthShellStep.addOutputDirectory(".");
        const codePipelineProps = {
            codePipeline,
            ...props,
            crossAccountKeys: undefined,
            synth: synthShellStep,
        };
        super(scope, id, codePipelineProps);
        this.id = id;
        this.codeRepository = codeRepository;
        this.sonarCodeScannerConfig = props.sonarCodeScannerConfig
            ? {
                cdkOutDir: props.primarySynthDirectory,
                ...props.sonarCodeScannerConfig,
            }
            : undefined;
        new aws_cdk_lib_1.CfnOutput(scope, "CodeRepositoryGRCUrl", {
            exportName: "CodeRepositoryGRCUrl",
            value: this.codeRepository.repositoryCloneUrlGrc,
        });
    }
    buildPipeline() {
        super.buildPipeline();
        this.sonarCodeScannerConfig &&
            new sonar_code_scanner_1.SonarCodeScanner(this, "SonarCodeScanner", {
                artifactBucketArn: this.pipeline.artifactBucket.bucketArn,
                artifactBucketKeyArn: this.pipeline.artifactBucket.encryptionKey?.keyArn,
                synthBuildArn: this.synthProject.projectArn,
                ...this.sonarCodeScannerConfig,
            });
        this.suppressCDKViolations();
    }
    suppressCDKViolations() {
        const stack = aws_cdk_lib_1.Stack.of(this);
        pdk_nag_1.PDKNag.addResourceSuppressionsByPathNoThrow(stack, `${pdk_nag_1.PDKNag.getStackPrefix(stack)}CodePipeline/Role/DefaultPolicy/Resource`, [
            {
                id: "AwsSolutions-IAM5",
                reason: "Actions contain wildcards which are valid for CodePipeline as all of these operations are required.",
                appliesTo: [
                    {
                        regex: "/^Action::s3:.*$/g",
                    },
                ],
            },
            {
                id: "AwsSolutions-IAM5",
                reason: "CodePipeline requires access to any and all artifacts in the ArtifactsBucket.",
                appliesTo: [
                    {
                        regex: "/^Resource::<ArtifactsBucket.*.Arn>/\\*$/g",
                    },
                ],
            },
        ]);
        pdk_nag_1.PDKNag.addResourceSuppressionsByPathNoThrow(stack, `${pdk_nag_1.PDKNag.getStackPrefix(stack)}CodePipeline/Source/CodeCommit/CodePipelineActionRole/DefaultPolicy/Resource`, [
            {
                id: "AwsSolutions-IAM5",
                reason: "Actions contain wildcards which are valid for CodePipeline as all of these operations are required.",
                appliesTo: [
                    {
                        regex: "/^Action::s3:.*$/g",
                    },
                ],
            },
            {
                id: "AwsSolutions-IAM5",
                reason: "CodePipeline requires access to any and all artifacts in the ArtifactsBucket.",
                appliesTo: [
                    {
                        regex: "/^Resource::<ArtifactsBucket.*.Arn>/\\*$/g",
                    },
                ],
            },
        ]);
        pdk_nag_1.PDKNag.addResourceSuppressionsByPathNoThrow(stack, `${pdk_nag_1.PDKNag.getStackPrefix(stack)}CodePipeline/Build/Synth/CdkBuildProject/Role/DefaultPolicy/Resource`, [
            {
                id: "AwsSolutions-IAM5",
                reason: "Actions contain wildcards which are valid for CodePipeline as all of these operations are required.",
                appliesTo: [
                    {
                        regex: "/^Action::s3:.*$/g",
                    },
                ],
            },
            {
                id: "AwsSolutions-IAM5",
                reason: "CodePipeline requires access to any and all artifacts in the ArtifactsBucket.",
                appliesTo: [
                    {
                        regex: "/^Resource::<ArtifactsBucket.*.Arn>/\\*$/g",
                    },
                ],
            },
            {
                id: "AwsSolutions-IAM5",
                reason: "CodePipeline requires access to manage logs and streams whose names are dynamically determined.",
                appliesTo: [
                    {
                        regex: `/^Resource::arn:${pdk_nag_1.PDKNag.getStackPartitionRegex(stack)}:logs:${pdk_nag_1.PDKNag.getStackRegionRegex(stack)}:${pdk_nag_1.PDKNag.getStackAccountRegex(stack)}:log-group:/aws/codebuild/<CodePipelineBuildSynthCdkBuildProject.*>:\\*$/g`,
                    },
                ],
            },
            {
                id: "AwsSolutions-IAM5",
                reason: "CodePipeline requires access to create report groups that are dynamically determined.",
                appliesTo: [
                    {
                        regex: `/^Resource::arn:${pdk_nag_1.PDKNag.getStackPartitionRegex(stack)}:codebuild:${pdk_nag_1.PDKNag.getStackRegionRegex(stack)}:${pdk_nag_1.PDKNag.getStackAccountRegex(stack)}:report-group/<CodePipelineBuildSynthCdkBuildProject.*>-\\*$/g`,
                    },
                ],
            },
        ]);
        pdk_nag_1.PDKNag.addResourceSuppressionsByPathNoThrow(stack, `${pdk_nag_1.PDKNag.getStackPrefix(stack)}${this.id}/UpdatePipeline/SelfMutation/Role/DefaultPolicy/Resource`, [
            {
                id: "AwsSolutions-IAM5",
                reason: "CodePipeline requires access to manage logs and streams whose names are dynamically determined.",
                appliesTo: [
                    {
                        regex: `/^Resource::arn:${pdk_nag_1.PDKNag.getStackPartitionRegex(stack)}:logs:${pdk_nag_1.PDKNag.getStackRegionRegex(stack)}:${pdk_nag_1.PDKNag.getStackAccountRegex(stack)}:log-group:/aws/codebuild/<${this.id}UpdatePipelineSelfMutation.*>:\\*$/g`,
                    },
                ],
            },
            {
                id: "AwsSolutions-IAM5",
                reason: "CodePipeline requires access to create report groups that are dynamically determined.",
                appliesTo: [
                    {
                        regex: `/^Resource::arn:${pdk_nag_1.PDKNag.getStackPartitionRegex(stack)}:codebuild:${pdk_nag_1.PDKNag.getStackRegionRegex(stack)}:${pdk_nag_1.PDKNag.getStackAccountRegex(stack)}:report-group/<${this.id}UpdatePipelineSelfMutation.*>-\\*$/g`,
                    },
                ],
            },
            {
                id: "AwsSolutions-IAM5",
                reason: "CodePipeline requires access to assume a role from within the current account in order to deploy.",
                appliesTo: [
                    {
                        regex: `/^Resource::arn:\\*:iam::${pdk_nag_1.PDKNag.getStackAccountRegex(stack)}:role/\\*$/g`,
                    },
                ],
            },
            {
                id: "AwsSolutions-IAM5",
                reason: "CodePipeline requires access to any and all artifacts in the ArtifactsBucket.",
                appliesTo: [
                    {
                        regex: "/^Resource::<ArtifactsBucket.*.Arn>/\\*$/g",
                    },
                ],
            },
            {
                id: "AwsSolutions-IAM5",
                reason: "CodePipeline requires access to list all buckets and stacks.",
                appliesTo: [
                    {
                        regex: "/^Resource::\\*$/g",
                    },
                ],
            },
        ]);
        pdk_nag_1.PDKNag.addResourceSuppressionsByPathNoThrow(stack, `${pdk_nag_1.PDKNag.getStackPrefix(stack)}${this.id}/UpdatePipeline/SelfMutation/Role/DefaultPolicy/Resource`, [
            {
                id: "AwsSolutions-IAM5",
                reason: "Actions contain wildcards which are valid for CodePipeline as all of these operations are required.",
                appliesTo: [
                    {
                        regex: "/^Action::s3:.*$/g",
                    },
                ],
            },
            {
                id: "AwsSolutions-IAM5",
                reason: "CodePipeline requires access to manage logs and streams whose names are dynamically determined.",
                appliesTo: [
                    {
                        regex: `/^Resource::arn:${pdk_nag_1.PDKNag.getStackPartitionRegex(stack)}:logs:${pdk_nag_1.PDKNag.getStackRegionRegex(stack)}:(<AWS::AccountId>|${stack.account}):log-group:/aws/codebuild/<${this.id}UpdatePipelineSelfMutation.*>:\\*$/g`,
                    },
                ],
            },
            {
                id: "AwsSolutions-IAM5",
                reason: "CodePipeline requires access to create report groups that are dynamically determined.",
                appliesTo: [
                    {
                        regex: `/^Resource::arn:${pdk_nag_1.PDKNag.getStackPartitionRegex(stack)}:codebuild:${pdk_nag_1.PDKNag.getStackRegionRegex(stack)}:${pdk_nag_1.PDKNag.getStackAccountRegex(stack)}:report-group/<${this.id}UpdatePipelineSelfMutation.*>-\\*$/g`,
                    },
                ],
            },
            {
                id: "AwsSolutions-IAM5",
                reason: "CodePipeline requires access to assume a role from within the current account in order to deploy.",
                appliesTo: [
                    {
                        regex: `/^Resource::arn:\\*:iam::${pdk_nag_1.PDKNag.getStackAccountRegex(stack)}:role/\\*$/g`,
                    },
                ],
            },
            {
                id: "AwsSolutions-IAM5",
                reason: "CodePipeline requires access to any and all artifacts in the ArtifactsBucket.",
                appliesTo: [
                    {
                        regex: "/^Resource::<ArtifactsBucket.*.Arn>/\\*$/g",
                    },
                ],
            },
            {
                id: "AwsSolutions-IAM5",
                reason: "CodePipeline requires access to list all buckets and stacks.",
                appliesTo: [
                    {
                        regex: "/^Resource::\\*$/g",
                    },
                ],
            },
        ]);
        pdk_nag_1.PDKNag.addResourceSuppressionsByPathNoThrow(stack, `${pdk_nag_1.PDKNag.getStackPrefix(stack)}${this.id}/Assets/FileRole/DefaultPolicy/Resource`, [
            {
                id: "AwsSolutions-IAM5",
                reason: "Asset role requires access to the Artifacts Bucket",
            },
        ]);
        cdk_nag_1.NagSuppressions.addStackSuppressions(stack, [
            {
                id: "AwsSolutions-CB4",
                reason: "Encryption of Codebuild is not required.",
            },
        ]);
    }
}
exports.PDKPipeline = PDKPipeline;
_a = JSII_RTTI_SYMBOL_1;
PDKPipeline[_a] = { fqn: "@aws-prototyping-sdk/pipeline.PDKPipeline", version: "0.3.10" };
//# sourceMappingURL=data:application/json;base64,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