# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['bbrecon', 'bbrecon.api', 'bbrecon.models', 'bin', 'bin.utils']

package_data = \
{'': ['*']}

install_requires = \
['httpx>=0.13.3,<0.14.0',
 'pydantic>=1.6.1,<2.0.0',
 'tabulate>=0.8.7,<0.9.0',
 'typer[all]>=0.3.1,<0.4.0']

entry_points = \
{'console_scripts': ['bbrecon = bin.app:main']}

setup_kwargs = {
    'name': 'bbrecon',
    'version': '0.0.14',
    'description': 'A client library and CLI for accessing the Bug Bounty Recon API',
    'long_description': '<dl>\n  <p align="center">\n    <img width="320px" src="https://raw.githubusercontent.com/serain/bbrecon/master/docs/logo_cropped.png">\n  </p>\n  <br />\n</dl>\n\nBug Bounty Recon (`bbrecon`) is Recon-as-a-Service for bug bounty hunters and security researchers. The API aims to provide a continuously up-to-date map of the "safe harbor" attack surface of the Internet, excluding out-of-scope targets.\n\nIt comes with a beautiful ergonomic CLI and Python library.\n\nThe service is free.\n\nThis repository holds the CLI and Python library. Please see [the website](https://bugbountyrecon.com/) for more details.\n\n## Important Notice\n\nWhile effort is taken to ensure the results returned by `bbrecon` are reliable and trustworthy, this service and its operators are in no way responsible for what you do with the data provided.\n\nDouble check your scopes and ensure you stay within safe harbors.\n\n## Features\n\n- **Public Programs** - public bug bounty programs indexed and searchable with filters (live)\n- **Domains** - all domains in scope across all programs (August 2020)\n- **Private Programs** - support for private programs (September 2020)\n- **Notifications** - webhook alerts when programs are created, updated or domains discovered (September 2020)\n- **Endpoints** - all HTTP and non-HTTP endpoints in scope across all programs (October 2020)\n\n## Status\n\n`bbrecon` is in a gradual **Beta** release phase; major features are released every few weeks to get feedback and fix kinks. You can sign up and start using it, but be aware that **breaking changes may be deployed without notice**. While the service and infrastructure is designed to scale, it is **not currently configured to serve a large global audience**. This will change, but for now YMMV.\n\n## Getting Started\n\n### API key\n\nFetch an API key from the Console: https://console.bugbountyrecon.com\n\nOnly Google SSO is supported at this time.\n\n### Installation\n\n```\n$ pip3 install bbrecon\n```\n\nIf you intend to use the CLI, you should permanently configure your key:\n\n```\n$ bbrecon configure key\nEnter your API key: YOUR_API_KEY\n```\n\nYou can alternatively set the `BBRECON_KEY` environment variable if you prefer.\n\n## CLI\n\nThe following will output all programs released in the last month that have "web" type targets (APIs/web apps):\n\n```\n$ bbrecon get programs --type web --since last-month\nSLUG                  PLATFORM     CREATED     REWARDS      MIN.BOUNTY    AVG.BOUNTY    MAX.BOUNTY      SCOPES  TYPES\ncybrary               bugcrowd     2020-07-22  fame         $0            $0            $0                   6  android,ios,web\nexpressvpn            bugcrowd     2020-07-14  cash,fame    $150          $1047         $2500               17  android,ios,other,web\nprestashop            yeswehack    2020-07-23  cash         $0            $0            $1000                1  web\n...\n```\n\nMost commands can output JSON to make it easy to work with your scripts. Try `--output json`:\n\n```\n$ bbrecon get programs --output json\n[\n    {\n        "url": "https://bugcrowd.com/optimizely",\n        "name": "Optimizely",\n        "platform": "bugcrowd",\n        "rewards": [\n            "cash",\n            "fame"\n        ],\n...\n```\n\nYou can get information about specific programs by passing one or many slugs to the `get programs` command:\n\n```\n$ bbrecon get programs twago optimizely\nSLUG        PLATFORM    CREATED     REWARDS    MIN.BOUNTY    AVG.BOUNTY    MAX.BOUNTY      SCOPES  TYPES\ntwago       intigriti   2020-04-09             $0            $0            $0                   5  web\noptimizely  bugcrowd    2018-03-22  cash,fame  $0            $750          $5000                6  web\n```\n\nTo get scopes for specific programs, use `get scopes`:\n\n```\n$ bbrecon get scopes rockset codefi-bbp\nSLUG        PLATFORM    TYPE    VALUE\nrockset     hackerone   web     console.rockset.com\nrockset     hackerone   web     docs.rockset.com\nrockset     hackerone   web     api.rs2.usw2.rockset.com\ncodefi-bbp  hackerone   web     activate.codefi.network\n```\n\nUse `--help` to get a list of filters for each command:\n\n```\n$ bbrecon get programs --help\n...\n                                  Output format.  [default: wide]\n  -n, --name TEXT                 Filter by name.\n  -t, --type TEXT                 Filter by scope type. Can be used multiple\n                                  times.\n\n  -r, --reward TEXT               Filter by reward type. Can be used multiple\n                                  times.\n\n  -p, --platform TEXT             Filter by platform. Can be used multiple\n                                  times.\n\n  --exclude-platform TEXT         Exclude specific platform. Ignored if\n                                  --platform was passed. Can be used multiple\n                                  times.\n\n  -s, --since TEXT                Filter by bounties created after a certain\n                                  date. A specific date in the format\n                                  \'%Y-%m-%d\' can be supplied. Alternatively,\n                                  the following keywords are supported:\n                                  \'yesterday\', \'last-week\', \'last-month\',\n                                  \'last-year\' as well as \'last-X-days\' (where\n                                  \'X\' is an integer).\n...\n```\n\nNote that some filters are lists, and can be used multiple times! If you wanted to get all programs that have mobile apps in scope you could run:\n\n```\n$ bbrecon get programs --type android --type ios\nSLUG                                              PLATFORM     CREATED     REWARDS      MIN.BOUNTY    AVG.BOUNTY    MAX.BOUNTY      SCOPES  TYPES\nsquare                                            bugcrowd     2018-03-22  cash,fame    $300          $492          $5000                4  android,ios,other,web\ngojek                                             bugcrowd     2018-03-22  cash,fame    $200          $618          $5000                4  android,ios,web\nsmartthings                                       bugcrowd     2018-03-22  fame         $0            $0            $0                   5  android,hardware,ios,web\n...\n```\n\n## Python\n\nYou are invited to check out this repo\'s codebase for more details, but to get started:\n\n```python3\nfrom bbrecon import BugBountyRecon\n\nbb = BugBountyRecon(token=API_TOKEN)\n\nprograms = bb.programs(\n    types=["web", "ios"],\n    platforms=["hackerone"],\n    rewards=["cash"],\n)\n\nfor program in programs:\n    print(f"{program.name} rewards up to ${program.maximum_bounty}!")\n    print(f"More information is available at: {program.url}")\n\n    for scope in program.in_scope:\n        if scope.type == "desktop":\n            print("Found a desktop app in scope for this program. Cool!")\n```\n\n## REST API\n\nYou can interact directly with the REST API if you prefer. Check out the API docs [here](https://docs.bugbountyrecon.com/index.html).\n',
    'author': None,
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
