# Generated by Django 2.2 on 2019-11-12 14:24

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('esi', '0005_remove_token_length_limit'),
        ('eveonline', '0010_alliance_ticker'),
    ]

    operations = [
        migrations.CreateModel(
            name='CorpStat',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('last_update', models.DateTimeField(auto_now=True)),
                ('corp', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to='eveonline.EveCorporationInfo')),
                ('token', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='esi.Token')),
            ],
            options={
                'verbose_name': 'corp stats',
                'verbose_name_plural': 'corp stats',
                'permissions': (('view_corp_corpstats', 'Can view corp stats of their corporation.'), ('view_alliance_corpstats', 'Can view corp stats of members of their alliance.'), ('view_state_corpstats', 'Can view corp stats of members of their auth state.'), ('view_all_corpstats', 'Can view all corp stats.')),
            },
        ),
        migrations.CreateModel(
            name='CorpMember',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('character_id', models.PositiveIntegerField()),
                ('character_name', models.CharField(max_length=50)),
                ('location_id', models.BigIntegerField()),
                ('location_name', models.CharField(blank=True, max_length=150, null=True)),
                ('ship_type_id', models.PositiveIntegerField()),
                ('ship_type_name', models.CharField(max_length=42)),
                ('start_date', models.DateTimeField()),
                ('logon_date', models.DateTimeField()),
                ('logoff_date', models.DateTimeField()),
                ('base_id', models.PositiveIntegerField(blank=True, null=True)),
                ('corpstats', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='members', to='corpstats.CorpStat')),
            ],
            options={
                'ordering': ['character_name'],
                'unique_together': {('corpstats', 'character_id')},
            },
        ),
    ]
