# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['hello_world',
 'kkappkit',
 'kkappkit.hello_world',
 'kkappkit.test_offline_params',
 'kkappkit.test_realtime_params',
 'test_offline_params',
 'test_realtime_params']

package_data = \
{'': ['*'],
 'kkappkit': ['.git/*',
              '.git/hooks/*',
              '.git/info/*',
              '.git/logs/*',
              '.git/logs/refs/heads/*',
              '.git/logs/refs/remotes/origin/*',
              '.git/objects/01/*',
              '.git/objects/03/*',
              '.git/objects/04/*',
              '.git/objects/06/*',
              '.git/objects/08/*',
              '.git/objects/09/*',
              '.git/objects/0b/*',
              '.git/objects/0c/*',
              '.git/objects/0d/*',
              '.git/objects/0e/*',
              '.git/objects/0f/*',
              '.git/objects/10/*',
              '.git/objects/12/*',
              '.git/objects/14/*',
              '.git/objects/15/*',
              '.git/objects/16/*',
              '.git/objects/1b/*',
              '.git/objects/1c/*',
              '.git/objects/1e/*',
              '.git/objects/23/*',
              '.git/objects/26/*',
              '.git/objects/28/*',
              '.git/objects/29/*',
              '.git/objects/2b/*',
              '.git/objects/2c/*',
              '.git/objects/2d/*',
              '.git/objects/2e/*',
              '.git/objects/31/*',
              '.git/objects/32/*',
              '.git/objects/35/*',
              '.git/objects/36/*',
              '.git/objects/38/*',
              '.git/objects/39/*',
              '.git/objects/3b/*',
              '.git/objects/3e/*',
              '.git/objects/3f/*',
              '.git/objects/40/*',
              '.git/objects/41/*',
              '.git/objects/43/*',
              '.git/objects/44/*',
              '.git/objects/45/*',
              '.git/objects/46/*',
              '.git/objects/49/*',
              '.git/objects/4d/*',
              '.git/objects/4f/*',
              '.git/objects/51/*',
              '.git/objects/52/*',
              '.git/objects/54/*',
              '.git/objects/55/*',
              '.git/objects/57/*',
              '.git/objects/59/*',
              '.git/objects/5b/*',
              '.git/objects/5c/*',
              '.git/objects/5d/*',
              '.git/objects/5e/*',
              '.git/objects/61/*',
              '.git/objects/62/*',
              '.git/objects/65/*',
              '.git/objects/66/*',
              '.git/objects/67/*',
              '.git/objects/68/*',
              '.git/objects/6b/*',
              '.git/objects/6c/*',
              '.git/objects/6e/*',
              '.git/objects/6f/*',
              '.git/objects/70/*',
              '.git/objects/72/*',
              '.git/objects/73/*',
              '.git/objects/75/*',
              '.git/objects/76/*',
              '.git/objects/77/*',
              '.git/objects/7b/*',
              '.git/objects/7e/*',
              '.git/objects/7f/*',
              '.git/objects/80/*',
              '.git/objects/81/*',
              '.git/objects/82/*',
              '.git/objects/83/*',
              '.git/objects/84/*',
              '.git/objects/87/*',
              '.git/objects/88/*',
              '.git/objects/89/*',
              '.git/objects/8b/*',
              '.git/objects/8c/*',
              '.git/objects/8d/*',
              '.git/objects/90/*',
              '.git/objects/91/*',
              '.git/objects/92/*',
              '.git/objects/94/*',
              '.git/objects/97/*',
              '.git/objects/98/*',
              '.git/objects/99/*',
              '.git/objects/9a/*',
              '.git/objects/9b/*',
              '.git/objects/9c/*',
              '.git/objects/9d/*',
              '.git/objects/9e/*',
              '.git/objects/9f/*',
              '.git/objects/a0/*',
              '.git/objects/a2/*',
              '.git/objects/a5/*',
              '.git/objects/a8/*',
              '.git/objects/a9/*',
              '.git/objects/aa/*',
              '.git/objects/ac/*',
              '.git/objects/b0/*',
              '.git/objects/b2/*',
              '.git/objects/b3/*',
              '.git/objects/b4/*',
              '.git/objects/b5/*',
              '.git/objects/b6/*',
              '.git/objects/b7/*',
              '.git/objects/b9/*',
              '.git/objects/ba/*',
              '.git/objects/bb/*',
              '.git/objects/bc/*',
              '.git/objects/bd/*',
              '.git/objects/be/*',
              '.git/objects/bf/*',
              '.git/objects/c0/*',
              '.git/objects/c1/*',
              '.git/objects/c2/*',
              '.git/objects/c3/*',
              '.git/objects/c6/*',
              '.git/objects/c7/*',
              '.git/objects/c8/*',
              '.git/objects/c9/*',
              '.git/objects/cd/*',
              '.git/objects/d5/*',
              '.git/objects/d6/*',
              '.git/objects/d7/*',
              '.git/objects/d8/*',
              '.git/objects/da/*',
              '.git/objects/dc/*',
              '.git/objects/dd/*',
              '.git/objects/e0/*',
              '.git/objects/e1/*',
              '.git/objects/e5/*',
              '.git/objects/e7/*',
              '.git/objects/e8/*',
              '.git/objects/e9/*',
              '.git/objects/ea/*',
              '.git/objects/eb/*',
              '.git/objects/ec/*',
              '.git/objects/f4/*',
              '.git/objects/f5/*',
              '.git/objects/f6/*',
              '.git/objects/f7/*',
              '.git/objects/f8/*',
              '.git/objects/f9/*',
              '.git/objects/fb/*',
              '.git/objects/fc/*',
              '.git/objects/fd/*',
              '.git/objects/fe/*',
              '.git/objects/ff/*',
              '.git/refs/heads/*',
              '.git/refs/remotes/origin/*',
              '.idea/.gitignore',
              '.idea/.gitignore',
              '.idea/.gitignore',
              '.idea/.gitignore',
              '.idea/.gitignore',
              '.idea/.gitignore',
              '.idea/encodings.xml',
              '.idea/encodings.xml',
              '.idea/encodings.xml',
              '.idea/encodings.xml',
              '.idea/encodings.xml',
              '.idea/encodings.xml',
              '.idea/inspectionProfiles/*',
              '.idea/kkappkit.iml',
              '.idea/kkappkit.iml',
              '.idea/kkappkit.iml',
              '.idea/kkappkit.iml',
              '.idea/kkappkit.iml',
              '.idea/kkappkit.iml',
              '.idea/misc.xml',
              '.idea/misc.xml',
              '.idea/misc.xml',
              '.idea/misc.xml',
              '.idea/misc.xml',
              '.idea/misc.xml',
              '.idea/modules.xml',
              '.idea/modules.xml',
              '.idea/modules.xml',
              '.idea/modules.xml',
              '.idea/modules.xml',
              '.idea/modules.xml',
              '.idea/vcs.xml',
              '.idea/vcs.xml',
              '.idea/vcs.xml',
              '.idea/vcs.xml',
              '.idea/vcs.xml',
              '.idea/vcs.xml']}

setup_kwargs = {
    'name': 'kkappkit',
    'version': '0.6.5',
    'description': 'A UI library and mini-framework based on Tkinter，aiming for rapid development of small tool applications.',
    'long_description': '# kkAppKit\n\nA UI library and mini-framework based on [Tkinter](https://wiki.python.org/moin/TkInter)，aiming for rapid development of  small tool applications.\n\n## Version\n1.0.0\n\n## Motivation\n\n### Back story\nOn a regular day, my colleagues ask me to write a small tool. So I roll up my sleeves and finish `myscript.py`. It works for me, that is, through command line (CLI):\n\n```sh\npython myscript.py -V -C config.json\n```\n\nI could tune the parameters through my JSON config file myself. But this doesn\'t please my non-engineer colleagues: They need intuitive control, i.e., a GUI. Then it takes a bit of work: Lay out the frontend controls, link them with backend data, and code up sophisticated behaviours.\n\nHowever, that\'s still not enough. Being agile, the tool will **never** be *complete*. It will remain bleeding-edge. Despite the instability, my colleagues need the freedom to tweak the data model and sometimes the GUI themselves. They also demand better diagnostics and error handling: "What\'s this KeyError here?". When that happens, I\'d have to run it under CLI mode to get a full picture of the backend, then dive in and weed out the cryptic log messages, a sin of sloppy programmers. \n\nImagine doing this all over again on their next request.\n\n"*There\'s gotta be a better way!*"\n\n### The Vision\nI must rapidly deliver my app to internal non-engineer users, so that it ...\n\n- supports both GUI and CLI mode, decoupling frontend and backend.\n- gives non-engineer user offline/realtime parameter controls, presets, and per-parameter help doc.\n- allows user to reflect changes in data to UI with little programmer help.\n- makes its runtime state as clear as possible to non-engineer, e.g., shows progress, pops up human-readable diagnostics upon errors.\n- reduces bloat from third-party dependencies such as huge app frameworks to simplify distribution.\n\nFor now, I don\'t aim at complex applications such as a digital audio workstation, nor do I try to attack aesthetics such as UI theming. Python is my language of choice.\n\n### Why Tkinter for the GUI?\nFrom the vision, Tkinter gives me the following benefits:\n\n- **It\'s always there!** It\'s a first-party standard library, which simplifies distribution.\n- **It\'s stable.** Being a binding to the dinasaur [Tcl/TK](https://www.tcl.tk), Tkinter rarely changes. I personally enjoy Tkinter\'s create-configure-bind-layout workflow.\n- **Its features seem good enough for writing small tools.** So far. Its widget set, though much smaller than its peers\', is compact and configurable. Native look and styling are possible.\n\n### What is this all about then?\nTkinter has well-known problems, such as:\n\n- The lack of a designer tool. You must code everything up.\n- Limited widget set with minimal documentation.\n- Being a language-binding of Tcl/TK, not very transparent despite being open source.\n\nHowever, only the first problem is a showstopper in my book: User needs to tweak the data model and UI without coding.\n\nSo a big part of this work is to support data reflection in UI for Tkinter, similar to [XRC for wxWidgets](https://docs.wxwidgets.org/3.1/overview_xrc.html). Other (on-going) features include providing specialized compound widgets, handling blocking and async controls transparently, etc.\n\n### Caveats\nMany third-party UI libs, such as the great [PySimpleGUI](https://github.com/PySimpleGUI/PySimpleGUI), aim at innovative workflows. Here, instead, I\'m only interested in building a thin layer upon Tkinter while keeping the familiar Tkinter flavour: The create-configure-bind-layout workflow.\n\nThe fundamental constraints I set for myself is that the reflection currently adopts a vertical layout, like an *endless page*, meaning all the controls are laid out in **rows** inside a scrollable frame, **one compound control per row**. This is inspired by many form-filling web interface, such as Google Chrome\'s settings page.\n\nAlso, being very new to UI development, I haven\'t found the right way to test Tkinter-based GUI automatically. So test framework is out of the equation at this point.\n\nYes, I believe this shall be my own pet project for a very long time. This doc is thus for my own reference as well, for now.\n\n\n## Getting started\n\n### Workflow\n\nThe typical workflow with kkAppKit:\n\n- Create a project folder and a main Python script.\n- Create and write up JSON configuration files: `app.json` and `default.json`. The former holds the control parameters and GUI specs the main script relies on; the latter holds the default preset of those parameters.\n- In the main script, write a main function. This function also accounts for the CLI mode of your app.  \n- In the main script, call a factory method among the kit\'s API to generate the GUI for you based on the config file. This method returns the Tkinter main top-level window, e.g., root. Launch your Tkinter main event loop from the root window.\n\n\n### Hello World!\nIf you skim through the source code section below, you might be scared at how incredibly long it looks like. It is long for a Hello World (80 lines). There are two reasons:\n\n- The goal of this example is to show a real picture of my day-to-day work. There is no hiding of necessary details there.\n- I follow `PEP8` as much as possible, so many lines could\'ve been merged into one, but I avoid that style here for readability.\n\nWith this very first example, we\'ll see a GUI that allows us to edit a text string and a number, and show them in a pop-up message box upon launching the main script under GUI mode, and prints out the same data under CLI mode.\n\nFirst we create a folder called `hello_world` and a config file `app.json` under it. This is our main config file. Our app gets its control parameters from this file. Let\'s edit the JSON file like this.\n\n```javascript\n{\n    "my_string": {\n        "Title": "My String:",\n        "Value": "Hello, world!",\n        "Action": "Copy",\n        "Help": "Our first string."\n    },\n    "my_number": {\n        "Title": "My Number:",\n        "Value": 0.5,\n        "Range": [\n            0.0,\n            1.0\n        ],\n        "Steps": [\n            0.01,\n            0.1\n        ],\n        "Precision": 4,\n        "Help": "Our first number."\n    }\n}\n```\nIn this file we defined the titles of the parameters, their values to start with, and their help doc. For the number, we also defined:\n\n- its value range: the `Range` field.\n- its two-level control granularity: a coarse step of 0.1 used by a slider widget, and a fine step of 0.01 used by a spinbox widget.\n- The precision of a decimal number: This controls how many digits we see in the spinbox as we tune the number.\n\nSecondly, we duplicate `app.json` and rename it to `default.json`. This will contain the default values when we reset the number using one of the kit\'s features.\n\nThen, we create our main script `hello.py`, which looks like this:\n\n```python\n# Import built-in modules.\nimport functools\nfrom os.path import abspath, basename, dirname, splitext\nfrom queue import Queue\nimport sys\n\n# Import project modules.\nimport kkgui as ui\nimport util\n\n#\n# Globals\n#\n__version__ = "0.0.1"\n_basename = splitext(basename(__file__))[0]\n_script_dir = abspath(dirname(__file__))\n_progress_queue = Queue()\n\n\ndef main(argv):\n    logger = util.build_logger(__file__)\n    prompt = ui.Prompt(logger, is_gui=util.is_gui_mode(sys.argv))\n\n    # Progress info and completion percentage.\n    progress = (\n        (\'Initializing\', 1),\n        (\'Working\', 20),\n        (\'Done\', 100)\n    )\n\n    # Make progress.\n    stage = 0\n    _progress_queue.put(progress[stage])\n\n    # Help info to show under CLI mode.\n    app_info = {\n        \'Script\': __file__,\n        \'Task\': \'Show a string and a number.\',\n        \'Version\': __version__\n    }\n    args = util.parse_args_config(argv, app_info)\n    config = util.load_json(args.cfg_file)  # arg is a list under CLI.\n\n    # Move the proressbar.\n    stage += 1\n    _progress_queue.put(progress[stage])\n\n    # Do work.\n    prompt.info(\'String: {}, Number: {}\'.format(\n        config[\'my_string\'][\'Value\'],\n        config[\'my_number\'][\'Value\']))\n\n    # Move the proressbar.\n    stage += 1\n    _progress_queue.put(progress[stage])\n    return 0\n\n\ndef run_gui():\n    """Run under GUI and non-verbose mode."""\n    root = ui.build_script_launcher(\n        title=_basename,\n        app_dir=_script_dir,\n        progress_queue=_progress_queue,\n        handlers={\n            \'OnQuit\': None,\n            \'OnSubmit\': functools.partial(\n                util.threaded_main,\n                target=main),\n            \'OnCancel\': None\n        },\n        window_size=(768, 300)\n    )\n    root.mainloop()\n\n\nif __name__ == \'__main__\':\n    if util.is_cli_mode(sys.argv):\n        sys.exit(main(sys.argv))\n    else:\n        run_gui()\n\n```\n\nWow! That is long! For a Hello World, what we did may seem an overkill. But wait, most of that is just necessary bootstrapping in a real-world tool and we are not shy from doing things properly; the only UI code in the example, however, is just the `run_gui()` function, which costs only two subroutines, one being a factory method. No need for explicit widget or layout coding here. All the details come from our `app.json` config file. Anybody can write up this config easily.\n\nAs said before, we include in this example the necessary features of a real-world tool according to our vision, e.g., transparency via showing progress and status, in this bare bone example. For anything larger than that, especially when it comes to realtime control via a ton of parameters, you will quickly see the benefits and the little boilerplate cost will be ignorable. But, we are not done yet.\n\nFinally, we copy `kkgui.py` and `util.py` modules into the app folder. Now we are ready to run this app.\n\nWe\'ll test the GUI mode first. Run `hello.py` with shell integration of Python 3, or open a Terminal or Command Prompt and type in `python3 hello.py`. You should see the following GUI (mine runs on macOS).\n\n![](hello_world/helloworld-gui.png)\n\nFrom top to bottom, you see:\n\n1. A search bar for filtering out widgets by keywords.\n2. The string parameter compound widget, with Reset and Help (?) buttons. \n3. The number parameter compound widget, with Reset and Help (?) buttons. \n4. A submission panel to launch main script and handle parameter presets.\n5. A status bar with a progressbar.\n\nNo. 1, 4, and 5 come for free as the kit\'s built-in widgets from calling the factory method `ui.build_script_launcher()`. The two core parameters show up in the order of their appearance in `app.json`.\n\nNow drag the slider or edit the spinbox so that the number shows `0.5`, then press the bottom-right button `Go!`. You\'ll see the following prompt:\n\n![](hello_world/helloworld-popup.png)\n\nThat concludes our GUI-mode example.\n\nNext we\'ll see about the CLI mode. Open your Terminal or Command Prompt and type in:\n\n```sh\npython3 hello.py -c\n```\n\nYou should see the same message as the prompt showing in the console.\n\n`-c` tells the script to load `app.json` for all the control parameters. Running the script without switches will launch the GUI.\n\nYou\'ll also notice that a log file `app.log` is automatically generated under the project folder. It contains all log messages from the app, which provides complete diagnostics for the bad times.\n\nThat\'s it for our Hello World.\n\n### Benefits\n\nYou can see that with kkAppKit, we can:\n\n- consolidate the GUI and CLI mode easily.\n- generate the GUI based on a config file.\n- focus on writing main logic and designing data model; \n- handle default values, presets, and per-parameter help documentation.\n- quickly modify the data model and doc, and reflect the changes onto the UI for free.\n- keep the app transparent by showing useful diagnostics (more on this later).\n\n### More examples\n\nThe hello-world example shows how to work out an offline control with the kkAppKit, i.e., the parameters are first saved into `app.json` before running the main script, and never changes during the run. Two more examples are included in sub-folders:\n\n- One shows a more complex offline case: To show text on top of a picture, with the font and colour of the text configurable, using the third-party lib PIL fork [pillow](https://python-pillow.org). \n- The other is a realtime control example: Playing an oscillator tone with minimal control such as frequency and gain, using [Csound](http://www.csounds.com) as the synth backend. The GUI talks to Csound using [Open Sound Control (OSC)](http://opensoundcontrol.org). Although Csound bundles a [FLTK](https://www.fltk.org) binding to allow mixed frontend and backend code, but here I decouple the frontend completely from the backend, which allows me to quickly switch to another synth backend later.\n\nThese are specialized examples and the code is straightforward to follow. So I\'ll skip the details here.\n\n## Installation\n\nFor now, simply copy `kkgui.py` and `util.py` to your app\'s folder.\n\n## Configuration\n\nkkAppKit defines a standard JSON data model for UI reflection. The format may undergo revision and new data-UI models may be added.\n\nThe format supports two types of top-level fields: \n\n- Controls, such as Check, Entry, Number, Options, and Path; these demand a Help field for documentation.\n- Cosmetics, such as Banner, Info, and Separator; these only affects the UI\'s look.\n\nThe order of fields in the JSON file represents the vertical order of appearance of their generated widgets.\n\nCAUTION: A top-level field name must be **all-lowercase ASCII** characters. This is because\n\n- top-level fields are used as Tkinter widget names, and Tkinter supports ASCII names only. \n- Tkinter widget instance names are case-insensitive while JSON fields are case-sensitive, so we might end up with conflicting fields if we use anything other than all-lowercasing. \n\n### Banner\n\nUse banner to group consecutive widgets under it. It\'s like a group title.\n\nSyntax\n\n```js\n"some_name": {\n        "Title": "Banner title"\n}\n```\n\n### Info\n\nUse Info to show static text such as author and version.\n\nSyntax\n\n```js\n"some_name": {\n    "Title": "some title",\n    "Value": "some content",\n    "Type": "Info"\n}\n```\n\n### Separator\n\nUse separator to visually separate widget rows.\n\nSyntax\n\n````js\n"some_name": {}\n````\n\n### Check\n\nUse Check for boolean flags.\n\nSyntax\n\n```js\n"some_name": {\n    "Title": "some title",\n    "Value": false,\n    "Help": "some help text."\n}\n```\n\n\n\n### Entry\n\nUse Entry for editable text string parameters. The `Copy` action below generates a button. If clicked, it copies the current string into your OS\'s clipboard.\n\nSyntax\n\n```js\n"some_name": {\n    "Title": "some_title",\n    "Value": "some content",\n    "Action": "Copy",\n    "Help": "some help text."\n}\n```\n\n### Path\n\nUse Path for file and folder path input. It derives from Entry. The `Browse` action below  generates a button, giving you the basic OS file dialog support.\n\nSyntax\n\n```js\n"some_name": {\n    "Title": "some title",\n    "Value": "/path/to/file.ext",\n    "Type": "Path",\n    "Action": "Browse ...",\n    "FileTypes": [\n        [\n            "Format 1",\n            "*.ext1"\n        ],\n        [\n            "Format 2",\n            "*.ext2"\n        ]\n    ],\n    "Help": "some help text."\n}\n```\n\n\n\n### Number\n\nUse Number for integer and decimal numbers. It supports both value range and two-level control granularity for spinbox and slider. Decimal numbers may need a precision field, default to 4 if none is specified. \n\nSyntax: Integer\n\n```js\n"color_r": {\n    "Title": "Color.R: ",\n    "Value": 255,\n    "Range": [\n    \t0,\n    \t255\n\t],\n    "Steps": [\n    \t1,\n        10\n    ],\n    "Help": "some help text."\n}\n```\n\nSyntax: Decimal\n\n```js\n"some_name": {\n    "Title": "some title",\n    "Value": 0.0,\n    "Range": [\n        0.0,\n        1.0\n    ],\n    "Steps": [\n        0.01,\n        0.1\n    ],\n    "Precision": 4,\n    "Help": "some help text."\n}\n```\n\n### Options\n\nUse Options for single-choice selection. The `Value` field must be a non-negative integer, representing the 0-based index of the option menu item. The `Options` field must include strings only.\n\nSyntax \n\n```js\n"some_name": {\n    "Title": "some title",\n    "Value": 0,\n    "Options": [\n        "option 1",\n        "option 2"\n    ],\n    "Help": "Font name of text to draw; actual font file to use depends on platforms."\n}\n```\n\n\n\n### Private Widgets\n\nOther than the data-model widgets for user to configure in apps, there are pre-defined widget classes for convenience. User has no access to them without coding. They are *hard-coded* and is thus not part of the JSON data-model.\n\n### ScrollFrame\n\nThis is the *endless page*. A frame with a vertical scrollbar where generated widgets reside. Combined with SearchBar, this makes it easy to add hundreds of parameter widgets under the vertical layout.\n\n### SearchBar\n\nUse this to show only the widgets relevant to a user-provided keyword. It starts filtering as you type. You can also narrow down the search scope with it. Call its `.configure_internal()` method to specify the scope.\n\nExample\n\n```python\nsearch_bar.configure_internal({\n    \'Scope\': {\n        \'Title\': \'Where\',\n        \'MultiOptions\': [\'Name\', \'Title\', \'Help\']\n    }\n})\n```\n\nThis tells the SearchBar to look for keywords under the `Name`, `Title`, and `Help` domains. What do these domains mean? They are some properties of a compound widget and are retrieved by calling the property accessors.\n\nYou can use SearchBar to  can be adapted to search for anything you want. Right now it\'s used for widgets because we only use it with `ScrollFrame`, which implements the `.filter_widgets()` method as SearchBar\'s `OnSearch` handler.\n\n### SubmitStrip\n\nThis compound widget handles preset save/load, and launching the main script. It\'s pretty simple and you can easily write up your own. But it\'s good enough for most offline/realtime tools. See in our examples about how to customize the submission buttons.\n\n### ProgressStrip\n\nThis widget wraps `ttk.ProgressBar` with a label, which shows a visual progress and a text one. The hello-world example already shows you how to use a queue to push progress info from the backend thread to the GUI thread. As with `ttk.ProgressBar`, it supports the `determinate` and `indeterminate` modes.\n\n## Compatibility\n\nCurrently the kit is only tested on macOS (High Sierra and Mojave), but there is no platform-specific code in the kit. It only supports Python 3 for future convenience.\n\n## Implementation details\n\n- Each compound widget supports Tkinter\'s geometry managers `pack` and `grid`. However, only `grid` is recommended because proper widget filtering is only possible with `grid`. `pack` makes it difficult to recall the original widget order after you revert the filtering.\n- The compound widgets all have their own handlers and properties in addition to their parent Tkinter widget properties. `.configure_internal()` method is used to configure the add-on properties. Their inherited `.configure()` is used for configure basic properties. Their overriden `.bind` is used to bind additional handlers.\n- A compound widget reuses the its top-level field name in the JSON config file as its name. This name registers with Tkinter.\n- The widget filtering based on SearchBar relies on a `eval()` call on special property accessors defined in widgets.\n- The `OnHelp` handler behind a Help(?) button can be used to retrieve help string in any form, you may also customize how to show the help, e.g., on a docked panel. By default, it gets the doc from the config file, and pops up a top-level window.\n- Prompt offers `.info()`, `.warning()`, and `.error()` methods, similar to the `logging` module, however, a twist here is that it enforces writing readable diagnostics. You must provide three pieces of info: description, cause, and suggestion. If a logger is given, calling these API will both pop up a prompt, and write log messages into `app.log`.\n\n\n## Acknowledgements\n\nI must thank the author of PySimpleGUI for his thorough documentation. His insight inspired me to think about my own problems and start working on my own pragmatic UI solution instead of making a blind committment to a random framework out there.\n',
    'author': 'Beinan Li',
    'author_email': 'li.beinan@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/kakyoism/kkappkit/',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
