# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['citation_graph']

package_data = \
{'': ['*']}

install_requires = \
['crossrefapi>=1.5.0,<2.0.0',
 'levenshtein>=0.20.8,<0.21.0',
 'networkx>=2.8.8,<3.0.0',
 'pyvis>=0.3.1,<0.4.0',
 'requests>=2.28.1,<3.0.0',
 'types-requests>=2.28.11.5,<3.0.0.0',
 'unidecode>=1.3.6,<2.0.0']

setup_kwargs = {
    'name': 'citation-graph',
    'version': '1.2.6',
    'description': 'Create a citation graph starting from a root paper',
    'long_description': '# Citation Graph\n\n<picture style="width: 750px;">\n  <source type="image/jpg" srcset="docs/screenshot1.jpg" style="width: 750px;" />\n  <img src=\'https://github.com/miile7/citation-graph/blob/main/docs/screenshot1.jpg?raw=true\' width="750px" alt="Overview over all citations" />\n</picture>\n<picture style="width: 750px;">\n  <source type="image/jpg" srcset="docs/screenshot2.jpg" style="width: 750px;" />\n  <img src=\'https://github.com/miile7/citation-graph/blob/main/docs/screenshot2.jpg?raw=true\' width="750px" alt="Hover over node for more details" />\n</picture>\n\nCitation Graph helps you creating a literature graph from one starting scientific\npublication. By the help of some scientific databases (currently only\n[semanticscholar.org](https://semanticscholar.org)) it starts from this paper and looks\nup the citations of this paper. Then the citations of those papers are looked up and so\non.\n\nEach request result is written to the local cache file. This means running the same (or\na subset of the) request will result in an instantaneous result by using the cached\nresults. If the parameters are changed, the cache is still used for those results that\nare known.\n\nFor some databases API keys lead to faster access, for others they are required for\ngetting results at all. This is supported by a database `config` file.\n\n## Key Features\n\n- Create Citation Graph starting from one paper by requesting information from online\n  databases\n- Merge results from different databases (Coming soon!)\n- Create citation list file (csv file)\n- Support API keys for (faster) access\n- Exclude irrelevant papers on collection\n- Use local cache for fast reproducible results\n\n## Recommended usage\n\nTo create a (more-less) full citation graph, the following procedure is recommended:\n\n1. (*Optional*): If you have API keys, copy the `config.example.ini`, rename it to\n   `config.ini` and fill in your keys\n2. Find your paper at any scientific search engine, then copy one of the ids,\n   preferable the DOI (other supported id types can be found by running\n   `citation_graph -h`)\n3. Start with a broad search with depth 2 (`-d=2`). This will find citations of papers\n   that cite the root paper. This shows citations that are no dead ends. Do not include\n   too many citations (the maximum citations can be controlled with `-m`). A too high\n   `m` on the first run will slow down the process unnecessarily because citations of\n   uninteresting works are collected. A good first run is e.g.:\n   `citation_graph -v -d=2 -m=100 <YOUR DOI>`\n4. Open the result graph and check the level-2-nodes, so the nodes that have two edges\n   between itself and the root (so `root`-`node`-`node`). Check those papers if they are\n   relevant for your search. If not, create a file `excluded.txt` and copy the id\n   from the graph to this file. Each id has to be in its own line (comment is #,\n   comments have to be in a separate line). All subsequent runs have to\n   include `-x=excluded.txt` to load the exclude file.\n5. Now step by step extend your search:\n   1. Extend the broadness by increasing `-m` while keeping the last `-d`, e.g.\n      `citation_graph -v -d=2 -m=200 -x=excluded.txt <YOUR DOI>`\n   2. Exclude irrelevant papers by traveling through the nodes with the most edges\n      between itself and the root. If a paper is not relevant for you, copy the id into\n      the `excluded.txt`.\n   3. Extend the depth by increasing `-d` (but narrow `-m` again), e.g.\n      `citation_graph -v -d=3 -m=100 -x=excluded.txt <YOUR DOI>` (compare `-m=100` to\n      `-m=200` in the previous run).\n   4. Exclude irrelevant papers, as described in step 4 or 5.2\n   5. Start over at 5.1\n   6. Repeat this until increasing `-d` and `-m` does not change the result graph\n      anymore (`citation_graph` will tell you about collecting papers for a specific\n      level, but no more requests are started). This means, no more papers can be\n      collected.\n6. Done. You found the full citation graph of your paper (where citations are mentioned\n   in at least one of the supported databases).\n\n\n## Installation\n\n### Via `pip`\n\n```bash\npip install citation-graph\n```\n\n### From source\nTo run this program from the code directly, [`python`](https://www.python.org/) and\n[`poetry`](https://python-poetry.org/) (`pip install poetry`) are required. Clone or\ndownload the repository.\n\nTo install all the dependencies, use your command line and navigate to the directory\nwhere this `README` file is located in. Then run\n\n```bash\npoetry install\n```\n\n### For development\n\nFor development installation perform the [From source](#from-source) installation.\n\nFor installing new packages, always run\n```\npoetry add <pip-package-name>\n```\ninstead of `pip install <pip-package-name>`.\n\nLaunch the program either check out the [Execution](#execution) section or use the\n*Run and Debug*-side panel of VSCode.\n\nIf the interpreter of the virtual environment does not show up in VSCode, add it\nmanually. The virtual environments are located in\n`{cache-dir}/virtualenvs/<venv-name>/Scripts/python.exe` where the\n[`{cache-dir}`](https://python-poetry.org/docs/configuration/#cache-dir) depends on the\noperating system (`~/.cache/pypoetry`, `~/Library/Caches/pypoetry` or\n`C.\\Users\\%USERNAME%\\AppData\\Local\\pypoetry\\Cache`).\n\n## Execution\n\n### For `pip` installation\n\nTo execute the program use\n```\npython -m citation_graph "<DOI>"\n```\n\n### For manual and development installation\n\nTo execute the program use\n```bash\npoetry run python -m citation_graph\n```\n\n### Parameters\n\n```\ncitation_graph  [-h] [--version] [-v] [-vv] [--max-depth MAX_DEPTH] [--clear-cache]\n                [--cache-path CACHE_PATH]\n                [--max-citations-per-paper MAX_CITATIONS_PER_PAPER]\n                [--politeness POLITENESS_FACTOR]\n                [--max-request-errors MAX_REQUEST_ERRORS]\n                [--exclude-papers [EXCLUDED_PAPERS ...]] [--list]\n                [--list-file-name LIST_FILE_NAME] [--no-graph]\n                [--database-config DATABASE_CONFIG]\n                [{doi,dblp,arxiv,corpusid}] id [name]\n```\n\n**positional arguments**\n- `{doi,dblp,arxiv,corpusid}` The id type, default is doi\n- `id` The id of the paper to use as the root, by default an doi is assumed, this can\n  be changed with the ID_TYPE parameter\n- `name` The name of the graph output html file, if not given, it will be in the current\n  working directory with the authors and the year as the file name.\n\n**optional arguments**\n- `-h`, `--help` Show this help message and exit\n- `--version`, `-V` Show program\'s version number and exit\n- `-v`, `--verbose` Set the loglevel to INFO\n- `-vv`, `--very-verbose` Set the loglevel to DEBUG\n- `--max-depth MAX_DEPTH`, `-d MAX_DEPTH` The maximum depth to search papers, if 0, only\n  the root paper is included in the result, default is 1\n- `--clear-cache`, `-c` Clear the cache before fetching. This ensures fresh data.\n- `--max-citations-per-paper MAX_CITATIONS_PER_PAPER`, `-m MAX_CITATIONS_PER_PAPER` The\n  maximum amount of citations to collect per paper, default is 300\n- `--politeness POLITENESS_FACTOR`, `-p POLITENESS_FACTOR` A factor that is multiplied\n  with the idle time that each database traverser waits between two requests, using\n  values >1 will be more polite but slow down the requests, values <1 will be faster but\n  may cause your IP being blocked, default is 1\n- `--max-request-errors MAX_REQUEST_ERRORS`, `-e MAX_REQUEST_ERRORS` The maximum number\n  of subsequent errors when requesting paper citations. If more than this specified\n  amount of errors occurs, a (temporary) block of requests is assumed by the database\n  due to too many requests. The default is 10\n- `--exclude-papers [EXCLUDED_PAPERS ...]`, `-x [EXCLUDED_PAPERS ...]` Define papers to\n  exclude from the result set, including intermediate result sets. This allows to\n  prevent fetching citations of papers that are not relevant for the current research\n  and therefore narrow down the selection. To define papers, use any id type followed by\n  the id, separated by \'::\', like so: {doi|dblp|arxiv|corpusid}::PAPER_ID. Alternatively\n  a path to a file can be given where the paper ids are listed, each paper id in a\n  separate line. Lines starting with a \'#\'-character are treated as comments and are\n  ignored entirely.\n- `--list`, `-l` Output a list containing the papers, ordered by their level.\n- `--list-file-name LIST_FILE_NAME`, `-n LIST_FILE_NAME` The file name of the list file,\n  by default the authors and the year are the file name. The file is created in the\n  current working directory\n- `--no-graph`, `-g` Use to prevent creating a visualization graph\n- `--database-config DATABASE_CONFIG`, `-s DATABASE_CONFIG` The path for additional\n  settings for the databases, e.g. API keys. Each database has its own section, the keys\n  depend on the database. If not given, the program will look for a file with the name\n  config.ini in the current working directory\n\n## Supported databases\n\n- ✅ https://semanticscholar.org/\n- ❌ https://api.crossref.org - Needs (payed) plus access, will not be implemented (in near future)\n- ❌ https://developer.ieee.org/ - Citations not supported\n- ⏳ https://api.base-search.net/\n- ⏳ https://core.ac.uk/services/api\n- ⏳ https://dev.elsevier.com/\n- ⏳ http://developers.amctheatres.com/\n- ⏳ Academic Knowledge API',
    'author': 'miile7',
    'author_email': 'None',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/miile7/citation-graph',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
