import * as cdk from '@aws-cdk/core';
/**
 * This struct provides the configuration required to construct an instance of @see SmtpCredentials.
 *
 * @stability stable
 */
export interface SmtpCredentialsProps {
    /**
     * The email address that the generated SMTP credentials will permit emails to be sent from.
     *
     * @stability stable
     */
    readonly emailAddress: string;
}
/**
 * This construct creates an IAM user, with a policy permitting emails to be sent via SES from a specified email address, creates an access key associated with this user, and converts the access key to SMTP credentials.
 *
 * The generated SMTP credentials are stored as a parameter in Parameter Store, and the name of
 * this parameter is output as a CloudFormation output. The parameter may be safely deleted, once
 * the credentials have been accessed.
 *
 * @stability stable
 * @example
 *
 * new SmtpCredentials(this, 'SmtpCredentials', {
 *     emailAddress: 'me@charles.fish',
 * });
 */
export declare class SmtpCredentials extends cdk.Construct {
    /**
     * @param scope A reference to the stack which this construct will be created in.
     * @param id A unique identifier, within the context that this construct is created.
     * @param props Configuration defining how this construct should be created.
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: SmtpCredentialsProps);
    private extractDomainName;
    private createIamUser;
    private createSmtpCredentials;
}
